using System;

public sealed partial class SupplementaryAreasPlugin
{
    /// <summary>
    /// Represents a person selected from the people picker
    /// </summary>
    internal sealed class Person
    {
        /// <summary>
        /// Microsoft Graph User ID (unique identifier)
        /// </summary>
        public string? GraphUserId { get; set; }

        /// <summary>
        /// Display name of the person
        /// </summary>
        public string? DisplayName { get; set; }

        /// <summary>
        /// Job title
        /// </summary>
        public string? JobTitle { get; set; }

        /// <summary>
        /// Email address
        /// </summary>
        public string? Mail { get; set; }

        /// <summary>
        /// User Principal Name
        /// </summary>
        public string? UserPrincipalName { get; set; }
    }
}

